/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Instance;
import weka.core.Option;
import weka.core.Utils;

public class CSV
extends AbstractOutput {
    private static final long serialVersionUID = 3401604538169573720L;
    protected String m_Delimiter = ",";

    @Override
    public String globalInfo() {
        return "Outputs the predictions as CSV.";
    }

    @Override
    public String getDisplay() {
        return "CSV";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tWhether to use TAB as separator instead of comma.\n\t(default: comma)", "use-tab", 0, "-use-tab"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseTab(Utils.getFlag("use-tab", options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        if (this.getUseTab()) {
            result.add("-use-tab");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setUseTab(boolean value) {
        this.m_Delimiter = value ? "\t" : ",";
    }

    public boolean getUseTab() {
        return this.m_Delimiter.equals("\t");
    }

    public String useTabTipText() {
        return "Whether to use TAB instead of COMMA as column separator.";
    }

    @Override
    protected void doPrintHeader() {
        if (this.m_Header.classAttribute().isNominal()) {
            if (this.m_OutputDistribution) {
                this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error" + this.m_Delimiter + "distribution");
                int i = 1;
                while (i < this.m_Header.classAttribute().numValues()) {
                    this.append(this.m_Delimiter);
                    ++i;
                }
            } else {
                this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error" + this.m_Delimiter + "prediction");
            }
        } else {
            this.append("inst#" + this.m_Delimiter + "actual" + this.m_Delimiter + "predicted" + this.m_Delimiter + "error");
        }
        if (this.m_Attributes != null) {
            this.append(this.m_Delimiter);
            boolean first = true;
            int i = 0;
            while (i < this.m_Header.numAttributes()) {
                if (i != this.m_Header.classIndex() && this.m_Attributes.isInRange(i)) {
                    if (!first) {
                        this.append(this.m_Delimiter);
                    }
                    this.append(this.m_Header.attribute(i).name());
                    first = false;
                }
                ++i;
            }
        }
        this.append("\n");
    }

    protected String attributeValuesString(Instance instance) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attributes != null) {
            this.m_Attributes.setUpper(instance.numAttributes() - 1);
            boolean first = true;
            int i = 0;
            while (i < instance.numAttributes()) {
                if (this.m_Attributes.isInRange(i) && i != instance.classIndex()) {
                    if (!first) {
                        text.append(this.m_Delimiter);
                    }
                    text.append(instance.toString(i));
                    first = false;
                }
                ++i;
            }
        }
        return text.toString();
    }

    @Override
    protected void doPrintClassification(double[] dist, Instance inst, int index) throws Exception {
        int prec = this.m_NumDecimals;
        Instance withMissing = (Instance)inst.copy();
        withMissing.setDataset(inst.dataset());
        double predValue = 0.0;
        predValue = Utils.sum(dist) == 0.0 ? Utils.missingValue() : (inst.classAttribute().isNominal() ? (double)Utils.maxIndex(dist) : dist[0]);
        this.append("" + (index + 1));
        if (inst.dataset().classAttribute().isNumeric()) {
            if (inst.classIsMissing()) {
                this.append(String.valueOf(this.m_Delimiter) + "?");
            } else {
                this.append(String.valueOf(this.m_Delimiter) + Utils.doubleToString(inst.classValue(), prec));
            }
            if (Utils.isMissingValue(predValue)) {
                this.append(String.valueOf(this.m_Delimiter) + "?");
            } else {
                this.append(String.valueOf(this.m_Delimiter) + Utils.doubleToString(predValue, prec));
            }
            if (Utils.isMissingValue(predValue) || inst.classIsMissing()) {
                this.append(String.valueOf(this.m_Delimiter) + "?");
            } else {
                this.append(String.valueOf(this.m_Delimiter) + Utils.doubleToString(predValue - inst.classValue(), prec));
            }
        } else {
            this.append(String.valueOf(this.m_Delimiter) + ((int)inst.classValue() + 1) + ":" + inst.toString(inst.classIndex()));
            if (Utils.isMissingValue(predValue)) {
                this.append(String.valueOf(this.m_Delimiter) + "?");
            } else {
                this.append(String.valueOf(this.m_Delimiter) + ((int)predValue + 1) + ":" + inst.dataset().classAttribute().value((int)predValue));
            }
            if (!Utils.isMissingValue(predValue) && !inst.classIsMissing() && (int)predValue + 1 != (int)inst.classValue() + 1) {
                this.append(String.valueOf(this.m_Delimiter) + "+");
            } else {
                this.append(String.valueOf(this.m_Delimiter));
            }
            if (this.m_OutputDistribution) {
                if (Utils.isMissingValue(predValue)) {
                    this.append(String.valueOf(this.m_Delimiter) + "?");
                } else {
                    this.append(this.m_Delimiter);
                    int n = 0;
                    while (n < dist.length) {
                        if (n > 0) {
                            this.append(this.m_Delimiter);
                        }
                        if (n == (int)predValue) {
                            this.append("*");
                        }
                        this.append(Utils.doubleToString(dist[n], prec));
                        ++n;
                    }
                }
            } else if (Utils.isMissingValue(predValue)) {
                this.append(String.valueOf(this.m_Delimiter) + "?");
            } else {
                this.append(String.valueOf(this.m_Delimiter) + Utils.doubleToString(dist[(int)predValue], prec));
            }
        }
        if (this.m_Attributes != null) {
            this.append(String.valueOf(this.m_Delimiter) + this.attributeValuesString(withMissing));
        }
        this.append("\n");
    }

    @Override
    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        double[] d = classifier.distributionForInstance(inst);
        this.doPrintClassification(d, inst, index);
    }

    @Override
    protected void doPrintFooter() {
    }
}

